#ifndef UTILS_H
#define UTILS_H


#include "types.h"
#include <CGAL/Regular_triangulation_3.h>
#include <CGAL/Regular_triangulation_euclidean_traits_3.h>



namespace BARY
{
	inline
		Point to_point(Vec3& p)
	{
		return Point(p[0], p[1], p[2]);
	}

	inline
		Vec3 to_vec3(Point& p)
	{
		return Vec3(p.x(), p.y(), p.z());
	}
	
	inline
		double length_aniso(Vec3 vec, double m_xx, double m_yy, double m_zz)
	{
		double square = m_xx*pow(vec[0], 2) + m_yy*pow(vec[1], 2)+m_zz*pow(vec[2],2);
		return std::sqrt(square);
	}


	inline
		double compute_triangle_area(Vec3& p1, Vec3& p2, Vec3& p3, Vec3& normal)
	{
		Vec3 f_normal = DDG::cross((p3 - p2), (p1 - p2));
		double f_area = f_normal.norm() / 2;
		f_normal.normalize();
		if (DDG::dot(f_normal, normal) > 0)
			return f_area;
		else
			return -f_area;
	}

	inline
		double compute_polygon_area(std::vector<Vec3>& points, Vec3& normal)
	{
		double area = 0;
		Vec3 p = points[0];
		for (int i = 1; i < points.size() - 1; i++)
			area += compute_triangle_area(p, points[i], points[i + 1], normal);

		return area;
	}	
}

#endif



